#include "userprocess.h"
#include <stdio.h>
#include "message.h"
#include "sn_debug.h"

User_Process::User_Process(int in_num_processes)
{
	// Pass any initialization values from the main program using this
	// constructor. However, this should be used strictly for
	// administrative initialization not directly related to the
	// simulation. Use Set_Start_State below for that.

	// This is just for show. You can pass whatever you want to the constructor.
	num_processes = in_num_processes;
}

// ----------------------------------------------------------------------------

void User_Process::Set_Start_State()
{
	// Set the starting state of all your state components here.
}

// ----------------------------------------------------------------------------

void User_Process::Generate_Messages()
{
	// Use this function for generating messages to other processes
	map<Message *,int> outgoing_messages;

	// Remember process ids are 1 based!
	int loop;
	for (loop = 1; loop <= num_processes; loop++)
	{
		// Create your outgoing message to each process and stick it
		// in outgoing_messages.
		Message* outgoing_message = new Message;
		/*
		outgoing_message->state1 = val1;
		outgoing_message->state2 = val2;
		*/

		// Create a Message-destination pair
		pair<Message *,int> msg_to_pair(outgoing_message, loop);
		outgoing_messages.insert(msg_to_pair);
	}

	// Always do this step. The SNF doesn't know about your Message type
	// --------------------------------
	// Convert Messages to SN_Messages
	map<SN_Message *,int> outgoing_sn_messages;

	map<Message *,int>::iterator a_message;
	for (a_message = outgoing_messages.begin();a_message != outgoing_messages.end();
		a_message++)
	{
		SN_Message* sn_message_ptr = reinterpret_cast<SN_Message *> (a_message->first);
		outgoing_sn_messages.insert(make_pair(sn_message_ptr,a_message->second));
	}
	// --------------------------------

	Send(&outgoing_sn_messages);

	// Delete the outgoing messages
	for (a_message = outgoing_messages.begin();a_message != outgoing_messages.end();
		a_message++)
	{
		delete (a_message->first);
	}
}

// ----------------------------------------------------------------------------

void User_Process::Transition(map<SN_Message *,int> inbound_sn_msgs)
{
	// Always do this step.
	// -----------------------------------------------------------
	// First convert all the SN_Messages to our Messages
	map<Message *,int> inbound_msgs;
	map<SN_Message *,int>::iterator an_sn_msg;
	
	for(an_sn_msg = inbound_sn_msgs.begin();
		an_sn_msg != inbound_sn_msgs.end(); an_sn_msg++)
	{
		Message *a_msg = reinterpret_cast<Message *>(an_sn_msg->first);
		inbound_msgs.insert(make_pair(a_msg,an_sn_msg->second));
	}
	// -----------------------------------------------------------

	// Here's where the guts of your process goes.
}
